% ALPHA ELECTRIC MOTOR DEFINITION
% Generated 29-May-2024 13:54:37

% SUGGESTED CITATION:
% Chevrolet Bolt BEV 150kW MOTO from 2016 SAE Paper - ALPHA Map Package. Version 2024-05. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, Advanced Technology Assessment Branch, 2024.


% Constructor
mg = class_REVS_emachine_geared();
mg.name =  'Chevrolet Bolt BEV 150kW MOTO from 2016 SAE Paper'; 
mg.source_filename = mfilename;

% Physical Description
mg.electrical_source =  'propulsion'; 
mg.inertia_kgm2 =  0.0380519; 
mg.type = enum_emachine_type.Motor;
mg.gear.ratio =  7.05; 
mg.gear.efficiency_norm =  1; 

% Capacity Limits
mg.max_speed_radps =  922.58104260420259; 
mg.max_torque_Nm =  360; 
mg.max_motor_power_W =  150000; 
mg.max_generator_power_W =  150000; 
mg.positive_torque_limit_Nm = class_REVS_dynamic_lookup;
mg.positive_torque_limit_Nm.axis_1.signal =  'emach_spd_radps'; 
mg.positive_torque_limit_Nm.axis_1.breakpoints = [	     2.1533041534382091	;     17.941433535523927	;     43.058702420423337	;     77.506033389179052	;     118.41235423720678	;     156.44760288065027	;     210.98967153836810	;     251.17822433524975	;     277.73102932244132	;     299.97814858379911	;     317.20181406817693	;     373.89626429829036	;     429.87294647725776	;     484.41501513497559	;     530.34478975998331	;     571.96795607811441	;     622.20433900999853	;     655.93390192760808	;     704.73382617615732	;     754.96928652699887	;     804.48790140773679	;     868.35818698722585	;     922.58104260420259		]; 
mg.positive_torque_limit_Nm.axis_2.signal =  'voltage_V'; 
mg.positive_torque_limit_Nm.axis_2.breakpoints =  350; 
mg.positive_torque_limit_Nm.table = [	     336.98268000000002	;     346.57848000000001	;     359.56079999999997	;     360.68976000000004	;     360.68976000000004	;     359.56079999999997	;     357.86772000000002	;     358.43220000000002	;     357.30324000000002	;     357.86772000000002	;     357.86772000000002	;     341.49815999999998	;     327.38688000000002	;     291.26123999999999	;     272.63412000000000	;     254.57147999999998	;     233.68643999999998	;     220.70375999999999	;     202.64111999999997	;     183.44952000000001	;     171.03131999999999	;     154.09764000000001	;     144.00000000000000		]; 

% Losses & Efficiency
mg.electric_power_W = class_REVS_dynamic_lookup;
mg.electric_power_W.axis_1.signal =  'emach_spd_radps'; 
mg.electric_power_W.axis_1.breakpoints = [	     0.0000000000000000	    53.931521822116942	    100.14857574108666	    139.61331515314833	    180.85834767086033	    204.97411364735919	    240.76314780548046	    279.12892411819519	    322.41769035865900	    377.25954886545469	    411.22797392897559	    449.81920288783374	    502.68679034506692	    548.40080786099861	    586.23533362227283	    628.82062895703439	    668.16204733879613	    692.34267094564166	    716.50509536005961	    730.11910485393332	    748.48927497968475	    771.99039421802274	    807.86429175115632	    843.15388795730735	    870.54009115298470	    922.58104260420259		]; 
mg.electric_power_W.axis_2.signal =  'emach_trq_Nm'; 
mg.electric_power_W.axis_2.breakpoints = [	     0.0000000000000000	    24.348253333333332	    42.740177837837834	    64.786018695652160	    78.210089999999994	    91.453366153846162	    107.44681500000000	    114.84836400000000	    124.23930923076924	    132.05566800000000	    145.77556390243899	    159.12906750000002	    166.63636800000000	    178.04960000000000	    190.78436842105259	    207.79741125000001	    220.02249599999999	    234.44286545454545	    255.28002749999996	    279.12442499999997	    306.55268999999993	    319.20510000000002	    332.64623999999998	    357.27551999999997		]; 
mg.electric_power_W.table = [
   -1.9661395029904905	    21.843149048458660	    32.945353328727947	    100.27889892368162	    169.11820976361764	    245.37234889732272	    341.42654470508950	    379.02007278929869	    423.07965467607306	    471.45164575736146	    651.85333034544715	    1011.7999389203237	    1231.3361142819999	    1563.4807987718846	    1887.3705337899632	    2164.7348966191371	    2238.6976794482425	    2238.2360152123356	    2273.4741648428503	    2929.7365919767067	    4059.2994204819115	    4628.0828261385514	    5243.1461578842654	    6437.5105344731091	;
    28.647906321298098	    1408.8237858147349	    2514.5365042107587	    3900.5884719882192	    4757.6159380854551	    5629.4767771709385	    6669.6246280344312	    7151.9751641800067	    7737.2087554132349	    8218.9294660244668	    9117.7858713733422	    10100.046866532597	    10670.970943452365	    11543.909676436240	    12540.133604448720	    13893.234092961025	    14786.045668282863	    15736.980720907046	    17036.796229917458	    19025.093214861459	    21675.334899095025	    22913.812270528240	    24253.597348378236	    26653.521774731293	;
    66.687368955096815	    2581.0263838477267	    4533.8002628559925	    6931.1234611400705	    8428.2443814757698	    9887.9820152442499	    11702.264664815197	    12555.643390626334	    13637.702780639236	    14540.164818249183	    16152.265026414940	    17723.474108012197	    18612.841582417244	    19971.641822661793	    21533.189607524313	    23707.569486049448	    25282.734791391627	    27122.482691427449	    29529.971443817794	    32680.243916789947	    36764.224611725505	    38596.857170387535	    40641.327609971559	    44019.895969098870	;
    95.980570835818213	    3586.7661130137126	    6271.9146646893905	    9550.2711973522892	    11563.760115204623	    13562.113219327926	    16009.544454366056	    17151.307871276938	    18608.820904113138	    19826.993882449438	    21991.303108968168	    24115.889779073390	    25306.860613720019	    27120.074463822126	    29193.248736141675	    32015.854490851390	    34055.256849586447	    36450.979781296315	    39956.230758312653	    44155.218642752981	    49538.967717958527	    52046.185702976982	    54686.521188725979	    59333.697652884075	;
    112.39725480799736	    4644.3096356497872	    8099.4932465807706	    12267.848990530643	    14826.728028261577	    17383.582946706181	    20496.487476969483	    21947.610452895762	    23799.254258219247	    25346.232084130650	    28081.527478597811	    30762.901772632813	    32283.835875796027	    34614.712443834935	    37234.831497892861	    40738.558666361248	    43283.417463722872	    46293.254851032587	    50765.703667602451	    55962.385756953336	    62340.833360090161	    65486.548483158018	    68882.719841279060	    75073.791583998202	;
    122.46362034668626	    5264.6167568526998	    9168.3731707869683	    13855.925329645966	    16732.874503594674	    19620.731907241516	    23127.944489970505	    24754.805147344152	    26826.219187828530	    28564.322180394298	    31638.564718073532	    34647.088762549065	    36349.002154179791	    38957.478480402177	    41901.517548819182	    45851.894652605137	    48698.886602390696	    52085.884061349527	    57055.923540784293	    62831.145461025881	    69740.038871173732	    73147.095632178301	    76822.081177451793	    83746.165714322138	;
    140.14227561804623	    6173.5262349463474	    10744.579810909336	    16237.719709941050	    19609.239917983992	    22975.003623220524	    27064.535784845430	    28955.478550862561	    31358.742696153968	    33368.825382432093	    36930.883691295152	    40423.880889851847	    42394.786716423885	    45400.902973388707	    48781.405299781509	    53359.711966971503	    56672.245709614333	    60611.775159318990	    66341.578411803057	    72967.735032343742	    80767.922763267634	    84452.460337808428	    88404.337030727256	    95975.753320272372	;
    164.35000733827349	    7139.3595940573286	    12440.530652240810	    18798.727721737654	    22689.501533767481	    26570.805381337948	    31277.338602345120	    33458.544682451473	    36228.717576937037	    38542.057035835431	    42624.742616757510	    46632.230756091201	    48895.840732579090	    52348.138419364397	    56210.187993097330	    61417.105114059312	    65196.257330079861	    69703.144609900235	    76265.827280595026	    83839.000943916835	    92705.140074238705	    96846.048798060147	    101247.37434626640	    109558.76692668605	;
    195.67080058082666	    8250.4861482978376	    14351.789044748981	    21661.807070176270	    26133.176051248429	    30588.517490782691	    35992.117743938368	    38500.325235996446	    41687.435556253055	    44345.315560795440	    49032.213344407952	    53633.563923114860	    56230.407854788238	    60187.004328036965	    64604.527827983824	    70578.145440253575	    74920.374868598636	    80032.835495787702	    87517.425773089286	    96215.373940860969	    106358.54563355436	    111140.01421392668	    116189.44160135115	    125503.23416947486	;
    238.38885057296204	    9663.3667655925692	    16779.947747072678	    25319.333828547486	    30532.024033874062	    35699.053153196110	    41979.768572658730	    44898.665066686575	    48609.409129462358	    51704.807991836024	    57148.724780179786	    62474.757950335217	    65483.837378294258	    70083.051965415085	    75222.980470443159	    82146.395163889640	    87240.974184646169	    93219.234745407579	    101729.64857065950	    112072.22833155870	    124227.66891801465	    129733.57265977051	    135614.57686800725	    146627.56445445938	;
    265.17940458543063	    10532.901199181682	    18280.128050506613	    27569.213029793049	    33246.420195727624	    38869.604598335762	    45697.043248920403	    48864.944344356969	    52888.963529394729	    56243.490758789405	    62152.022370016683	    67967.973627057785	    71234.666097234163	    76195.296653045210	    81720.626026278376	    89271.402033782739	    94838.137158004392	    101365.42880684003	    110615.41252494417	    121876.44708324426	    135243.71672431749	    141259.85837606929	    147744.57895668081	    159790.91843377386	;
    295.88016846544230	    11519.395285980927	    19992.018958751560	    30115.808760870153	    36325.120246952458	    42477.062015853713	    49939.021840847454	    53400.039894828049	    57797.009277652185	    61464.164145517090	    67931.439705645578	    74277.396364515444	    77850.684832479994	    83277.840901306918	    89383.165425025072	    97662.552581831900	    103681.75069311973	    110810.43928884949	    121240.42485651048	    133817.28600483877	    148442.50970550595	    154762.74865003765	    161788.89998310103	    174903.92142932792	;
    343.07528389601379	    12881.014818661795	    22351.290039660475	    33609.314954306137	    40565.166406103344	    47460.756405043539	    55821.094446211115	    59702.964514405721	    64638.247423667075	    68756.838696940904	    76016.870218737356	    83129.381311732956	    87156.856335115270	    93326.732718979329	    100265.00804291115	    109557.40403888471	    116388.64950000623	    124518.12239276452	    136905.80028089508	    151606.54253655841	    167395.44492480444	    174425.49356184571	    181970.55028411059	    196115.54150756530	;
    399.05233225643775	    14052.519750438674	    24378.221784953705	    36705.532621142112	    44324.415128483408	    51852.037431162717	    60983.043591695612	    65233.786147047198	    70644.159723126359	    75161.591217965455	    83115.821390444311	    90932.449341563901	    95376.110783395095	    102156.20615446508	    109749.81259450412	    120083.19057294777	    127762.30418520882	    137086.63010532857	    150912.71149646802	    166605.43166771272	    183803.77430356547	    191588.92390150912	    199841.41314293176	    215031.49732024001	;
    458.07547050657053	    15036.428554484632	    26078.451973835934	    39370.170133167972	    47499.190586070297	    55515.027526995938	    65291.633664663277	    69849.522323081721	    75655.253816134180	    80491.561427036213	    89027.068800052672	    97466.537830686168	    102242.66872447832	    109539.73967017431	    117771.61598429490	    129114.19329041916	    137667.27477772941	    147866.45679132285	    162550.72240760544	    179058.61365652460	    197468.20797194389	    205855.41195279820	    214733.44499809580	    230952.05238199129	;
    534.34574803200985	    16220.256539144588	    28007.600527191764	    42329.473788268981	    51025.537420413741	    59631.726427871894	    70214.572546009702	    75136.801026630812	    81392.167588060314	    86603.926515667728	    95831.751522831401	    104967.84503868139	    110144.65757967527	    118075.82545123913	    127149.27031064326	    140058.71509561042	    149353.23008946169	    160161.24105004099	    175653.97939657953	    193153.91491679140	    212932.29927297574	    221982.18303237873	    231568.68266375369	    249061.86193489074	;
    600.27256002613524	    17325.333820998105	    29900.978599513885	    45114.381385701621	    54341.775646654758	    63554.176714577072	    74874.922648847016	    80119.403137702422	    86788.203490667758	    92364.270358478403	    102246.73166423234	    112032.82468350574	    117643.63077186891	    126373.92255240605	    136516.21307743422	    150318.63430964356	    160034.10233133798	    171415.06595034941	    187739.44838628583	    206239.87416278585	    227286.84367074203	    236944.53055053126	    247185.07073955267	    265897.18126664369	;
    641.53596973057631	    17986.676575266767	    31079.681979382683	    46797.244872520896	    56400.097037358435	    65998.853362385082	    77737.046721764855	    83186.027285481076	    90124.806463584580	    95931.664645148077	    106222.49873122055	    116460.80872151874	    122407.29826819082	    131699.20335803580	    142296.79903420969	    156463.37757394215	    166509.82427895238	    178277.34998644202	    195152.68132955764	    214298.36748698750	    236130.54201236507	    246161.66260584441	    256803.59115502529	    276265.11883109220	;
    686.47367162486466	    18665.728844238871	    32276.241125545675	    48531.736528830799	    58489.882887187567	    68435.652957771221	    80592.681227159526	    86254.162698550950	    93468.728027087171	    99508.257932039065	    110224.10756374021	    121039.72308199212	    127334.91431869827	    137079.95083959235	    148009.05625014403	    162562.49697777809	    172937.75928481307	    185102.85196838068	    202549.66677760857	    222356.57952776752	    244977.90161440370	    255382.36078071143	    266424.89458727004	    286632.50878691749	;
    714.32291157411078	    19053.027388076309	    32947.185933131303	    49532.271225084194	    59682.838275682836	    69813.357361218557	    82207.055494496279	    87988.108755749141	    95357.987265752061	    101531.49469200463	    112521.41993680161	    123696.31088266231	    130163.78988530635	    140106.06201173743	    151208.48126037751	    165990.90003261509	    176549.61036371731	    188939.44788231980	    206713.47335454487	    226897.89722288173	    249965.72099638206	    260580.64803018761	    271848.71020307031	    292475.33646237419	;
    754.80166069223708	    19580.224146410281	    33847.229428261358	    50890.662049849365	    61298.905149828715	    71679.216968801207	    84393.564607383014	    90335.611245250693	    97913.235757216142	    104270.72821315598	    115663.21583616491	    127316.47176932263	    133996.36919999484	    144172.06087322699	    155509.84431165439	    170610.36671076357	    181415.84432077032	    194108.86700063222	    212328.25068030998	    233026.32826541999	    256698.50310738734	    267597.55385782430	    279169.75704003195	    300360.43293895206	;
    813.32332857319795	    20263.575547456698	    34986.431910808766	    52605.111191782402	    63362.372390749340	    74081.546747519620	    87211.614291860984	    93361.390661697456	    101206.87330093475	    107822.24812083408	    119799.69247546110	    131974.69435436593	    138862.78715934628	    149328.43363506670	    160982.14881678356	    176506.12966588265	    187629.01200125666	    200709.79051243258	    219504.18363065374	    240866.86044163167	    265316.09857017297	    276578.93028509698	    288539.88892940525	    310449.50249765284	;
    920.56794776073150	    21345.774043000110	    36757.556408417156	    55095.885907356191	    66479.401820712752	    77797.339864654175	    91592.800926832671	    98073.119774599370	    106332.33394054629	    113362.55856798400	    126247.81062142213	    139011.56666130951	    146189.11494887603	    157099.48076606801	    169258.73165796677	    185465.13150382132	    197084.33467939164	    210761.11079030292	    230441.66461172741	    252834.55558251747	    278480.16838276229	    290299.20665326808	    302852.88289935916	    325853.70047569415	;
    1039.3975289521563	    22406.713658963592	    38522.366104636567	    57652.915980372338	    69565.522535372831	    81436.348534742196	    95953.063930481047	    102771.54841936352	    111528.34835696539	    119026.86845020647	    132571.00077874103	    145832.30043552860	    153300.25370448740	    164660.42975998751	    177331.93824356995	    194234.34519641657	    206356.44544465703	    220630.29412537935	    241189.17470096206	    264605.47726302379	    291436.97822064877	    303804.20530199894	    316940.62196910859	    341010.18124569254	;
    1134.4910059947522	    23206.794596340151	    39866.055381342259	    59688.952446740281	    71999.063623206632	    84288.527530299019	    99409.519325896486	    106555.33952040985	    115748.94896346462	    123527.82467188641	    137434.74686852482	    151094.43316753666	    158791.02949639727	    170503.24274399880	    183575.22807713848	    201023.73570201415	    213541.18168710193	    228283.49672871578	    249527.03862333720	    273739.49804128212	    301493.79782449518	    314286.83744975948	    327875.51874537551	    352773.38285311521	;
    1318.5213470476433	    24653.892262295656	    42274.335776436499	    63497.264881980562	    76655.608882301502	    89849.679936221102	    106196.15410672502	    113898.82687399822	    123756.53843665670	    132021.70147899253	    146665.23180094900	    161064.43510489530	    169189.60087665138	    181568.40908201481	    195404.21127479573	    213898.68382764529	    227175.38202443838	    242817.18051333725	    265368.44081475679	    291095.53965605650	    320606.53858134116	    334209.40232620505	    348657.74565086450	    375128.52409839322	]; 
mg.unpowered_torque_loss_Nm = class_REVS_dynamic_lookup;
mg.unpowered_torque_loss_Nm.axis_1.signal =  'emach_spd_radps'; 
mg.unpowered_torque_loss_Nm.axis_1.breakpoints = [	    -15000.000000000000	    15000.000000000000		]; 
mg.unpowered_torque_loss_Nm.table = [	     0.0000000000000000	    0.0000000000000000		]; 
